<%@ Page Title="Action Tracking" EnableEventValidation="false" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="AdminActionTracking" Codebehind="AdminActionTracking.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList" TagPrefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Administration > Action Tracking"/>
    </div>   
    <asp:Panel ID="Panel1" runat="server"> 
    <asp:Panel ID="PanelSearchCriteria" runat="server" GroupingText="User Search Criteria">
    <table>
        <tr>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLastName" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxFirstName" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:BaseControlDropDownList ID="BaseControlDropDownListUserRole" runat="server" /></td>
        </tr>
    </table>
    </asp:Panel>
    <asp:Panel ID="PanelSearchCriteriaAction" runat="server" GroupingText="Action Search Criteria">
    <table>
        <tr>
            <td><UserControl:BaseControlDropDownList ID="BaseControlDropDownListActionType" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:UserControlFromToDate ID="UserControlDateRangeActionDate" runat="server" /></td>
        </tr>
    </table>
    </asp:Panel>
    <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please enter at least one of the following fields: Last Name, First Name, User Role, Action Type, or Date Range."
    ValidationGroup="SearchUser" ForeColor="Red"></asp:CustomValidator>
   <br />
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Button ID="Search" runat="server" onclick="ButtonSearch_Click" Text="&nbsp;Search&nbsp;" ValidationGroup="SearchUser" />
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    <asp:Button runat="server" ID="ButtonClear" Text="&nbsp;&nbsp;Clear&nbsp;&nbsp;" OnClick="ButtonClear_Click"/> 
    <br />
    </asp:Panel>
    <br />
    <asp:Panel ID="PanelUsersList" runat="server"  Width="80%">
        <asp:Label runat="server" ID="LabelNumberOfUsersFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right; width: 80%;" runat="server" id="pageSizeDiv">
            <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                    AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
            <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                <asp:ListItem Text="10" Value="10"></asp:ListItem>
                <asp:ListItem Text="25" Value="25"></asp:ListItem>
                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                <asp:ListItem Text="100" Value="100"></asp:ListItem>
            </asp:DropDownList>
        </div>
        <asp:GridView ID="GridViewUser" runat="server" DataKeyNames="USER_ID" AutoGenerateColumns="False" Visible="false"
                AllowPaging="True" Caption="To sort please click table headings" AllowSorting="True"  Width="80%"
                EmptyDataText="No Users Found." PageSize="10" PagerSettings-Mode="Numeric"
                OnRowCommand = "GridViewUser_RowCommand" OnSorting='GridViewUser_Sorting'
                OnPageIndexChanging='GridViewUser_PageIndexChanging'>
        <EmptyDataTemplate>
                    &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    No Users Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" 
                ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select" HeaderText ="Action" />
            <asp:TemplateField HeaderText="ID"  AccessibleHeaderText="ID" SortExpression="USER_ID" >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelUserId" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("USER_ID")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
                
            <asp:TemplateField HeaderText="User Name" SortExpression="FULL_NAME" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelFullName" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("FULL_NAME"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
                <asp:TemplateField HeaderText="Role">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelUserRoles" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ROLES"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Username" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelUsername" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("USERNAME"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            </Columns>
        </asp:GridView>

        <asp:GridView ID="GridViewAuditLog" runat="server" AutoGenerateColumns="False" EnableModelValidation="True"  Visible="false"
                AllowPaging="True" Caption="To sort please click table headings" AllowSorting="True" 
                EmptyDataText="No Records Found." PageSize="10" PagerSettings-Mode="Numeric" 
                OnPageIndexChanging='GridViewAuditLog_PageIndexChanging' OnSorting='GridViewAuditLog_Sorting' >
        <EmptyDataTemplate>
                    &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    No Records Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>            
            <asp:TemplateField HeaderText="User Name" SortExpression="FULL_NAME" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelFullName" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("FULL_NAME"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Date Time" SortExpression="CREATED" >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDateTime" runat="server" Width="170" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("CREATED")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
                
            <asp:TemplateField HeaderText="Action"  SortExpression="ACTION_TYPE" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelActionType" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ACTION_TYPE"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

                <asp:TemplateField HeaderText="Details">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelAuditDetails" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("DETAILS"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="# Sent" >
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelNumOfRegistrants" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("NUM_REGISTRANTS"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </asp:Panel>
    <asp:HiddenField runat="server" ID="HiddenFieldSort" />

</asp:Content>

